from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class SpitefulCC(Player):
    """
    Behaves like Grudger after cooperating for 2 turns

    Names:

    - spiteful_cc: [Mathieu2015]_
    """

    name = "SpitefulCC"
    classifier = {
        "memory_depth": float("inf"),  # Long memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    @staticmethod
    def strategy(opponent: Player) -> Action:
        """
        Cooperates until the opponent defects. Then defects forever.
        Always cooperates twice at the start.
        """
        if len(opponent.history) < 2:
            return C
        elif opponent.defections:
            return D
        return C